<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'signaturestyle' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_vbsignatures_style_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['title'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['display_order'];
	
	// Hook goes here
	
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];
	
	
	if (count(VBSIGNATURES::$cache['signaturestyle']))
	{
		print_form_header('vbsignatures', 'signaturestyle');	
		construct_hidden_code('action', 'displayorder');
		print_table_header($vbphrase['dbtech_vbsignatures_style_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbsignatures_style_management_descr'], false, count($headings));	
		print_cells_row($headings, 0, 'thead');
		
		foreach ((array)VBSIGNATURES::$cache['signaturestyle'] as $signaturestyleid => $signaturestyle)
		{
			// Table data
			$cell = array();
			$cell[] = $signaturestyle['title'];
			$cell[] = $signaturestyle['description'];
			$cell[] = ($signaturestyle['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$signaturestyleid]\" value=\"$signaturestyle[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
			
			// Hook goes here
			
			$cell[] = construct_link_code($vbphrase['edit'], 'vbsignatures.php?' . $vbulletin->session->vars['sessionurl'] . 'do=signaturestyle&amp;action=modify&amp;signaturestyleid=' . $signaturestyleid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbsignatures.php?' . $vbulletin->session->vars['sessionurl'] . 'do=signaturestyle&amp;action=delete&amp;signaturestyleid=' . $signaturestyleid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		print_submit_row($vbphrase['save_display_order'], false, count($headings), false, "<input type=\"button\" id=\"addnew\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_vbsignatures_add_new_style'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'vbsignatures.php?do=signaturestyle&amp;action=modify'\" />");	
	}
	else
	{
		print_form_header('vbsignatures', 'signaturestyle');	
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbsignatures_style_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbsignatures_no_styles'], false, count($headings));
		print_submit_row($vbphrase['dbtech_vbsignatures_add_new_style'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$signaturestyleid = $vbulletin->input->clean_gpc('r', 'signaturestyleid', TYPE_UINT);
	$signaturestyle = ($signaturestyleid ? VBSIGNATURES::$cache['signaturestyle'][$signaturestyleid] : false);
	
	if (!is_array($signaturestyle))
	{
		// Non-existing style
		$signaturestyleid = 0;
	}
	
	// Create array of usergroups
	$usergroups = array();
	foreach ((array)$vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		$usergroups[$usergroupid] = $usergroup['title'];
	}
	
	$headings = array(
		$vbphrase['usergroup'],
		$vbphrase['dbtech_vbsignatures_can_access']
	);	
	
	$defaults = array(
		'title' 		=> 'Example Signature Style 1',
		'description' 	=> 'Signature style description.',
		'active' 		=> 1,
		'displayorder' 	=> 10,
	);
	
	if ($signaturestyleid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbsignatures_editing_x_y'], $vbphrase['dbtech_vbsignatures_style'], $signaturestyle['title'])));
		print_form_header('vbsignatures', 'signaturestyle');
		construct_hidden_code('action', 'update');
		construct_hidden_code('signaturestyleid', $signaturestyleid);
		print_table_header(construct_phrase($vbphrase['dbtech_vbsignatures_editing_x_y'], $vbphrase['dbtech_vbsignatures_style'], $signaturestyle['title']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_vbsignatures_add_new_style']);
		print_form_header('vbsignatures', 'signaturestyle');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_vbsignatures_add_new_style']);
		
		// Start with the default data
		$signaturestyle = $defaults;
	}
		
	print_input_row($vbphrase['title'], 			'signaturestyle[title]', 		$signaturestyle['title']);
	print_textarea_row($vbphrase['description'], 	'signaturestyle[description]', 	$signaturestyle['description']);
	print_yes_no_row($vbphrase['active'],			'signaturestyle[active]',		$signaturestyle['active']);
	print_input_row($vbphrase['display_order'], 	'signaturestyle[displayorder]', $signaturestyle['displayorder']);
	print_cells_row($headings, 0, 'thead');
	foreach ((array)$vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		print_yes_no_other_row($usergroup['title'], 'signaturestyle[permissions][' . $usergroupid . ']', $vbphrase['default'], (isset($signaturestyle['permissions'][$usergroupid]) ? $signaturestyle['permissions'][$usergroupid] : -1));
	}
	print_submit_row(($signaturestyleid ? $vbphrase['save'] : $vbphrase['dbtech_vbsignatures_add_new_style']));	
}

// #############################################################################
if ($_REQUEST['action'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'signaturestyleid' 	=> TYPE_UINT,
		'signaturestyle' 	=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& VBSIGNATURES::initDataManager('Signaturestyle', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['signaturestyleid'])
	{
		if (!$existing = VBSIGNATURES::$cache['signaturestyle'][$vbulletin->GPC['signaturestyleid']])
		{
			// Couldn't find the style
			print_stop_message('dbtech_vbsignatures_invalid_x', $vbphrase['dbtech_vbsignatures_style'], $vbulletin->GPC['signaturestyleid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
				
		// Added
		$phrase = $vbphrase['dbtech_vbsignatures_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_vbsignatures_added'];
	}
	
	// style fields
	foreach ($vbulletin->GPC['signaturestyle'] AS $key => $val)
	{
		if (!$vbulletin->GPC['signaturestyleid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
		
	define('CP_REDIRECT', 'vbsignatures.php?do=signaturestyle');
	print_stop_message('dbtech_vbsignatures_x_y', $vbphrase['dbtech_vbsignatures_style'], $phrase);
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$vbulletin->input->clean_array_gpc('p', array('order' => TYPE_ARRAY));
	
	if (is_array($vbulletin->GPC['order']))
	{
		foreach ($vbulletin->GPC['order'] as $signaturestyleid => $displayorder)
		{
			if (!$existing = VBSIGNATURES::$cache['signaturestyle'][$signaturestyleid])
			{
				// Couldn't find the style
				continue;
			}
			
			if ($existing['displayorder'] == $displayorder)
			{
				// No change
				continue;
			}
			
			// init data manager
			$dm =& VBSIGNATURES::initDataManager('Signaturestyle', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('displayorder', $displayorder);
			$dm->save();
			unset($dm);	
		}
	}
	
	define('CP_REDIRECT', 'vbsignatures.php?do=signaturestyle');
	print_stop_message('saved_display_order_successfully');	
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'signaturestyleid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_vbsignatures_delete_x'], $vbphrase['dbtech_vbsignatures_style']));
	print_delete_confirmation('dbtech_vbsignatures_signaturestyle', $vbulletin->GPC['signaturestyleid'], 'vbsignatures', 'signaturestyle', 'dbtech_vbsignatures_signaturestyle', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_gpc('r', 'signaturestyleid', TYPE_UINT);
	
	if (!$existing = VBSIGNATURES::$cache['signaturestyle'][$vbulletin->GPC['signaturestyleid']])
	{
		// Couldn't find the style
		print_stop_message('dbtech_vbsignatures_invalid_x', $vbphrase['dbtech_vbsignatures_style'], $vbulletin->GPC['signaturestyleid']);
	}
	
	// init data manager
	$dm =& VBSIGNATURES::initDataManager('Signaturestyle', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbsignatures.php?do=signaturestyle');
	print_stop_message('dbtech_vbsignatures_x_y', $vbphrase['dbtech_vbsignatures_style'], $vbphrase['dbtech_vbsignatures_deleted']);	
}

print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: style.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>